<?php
/**
 * Plugin Name: GLS • Hardening (Head Cleanup + No-Duplicate SEO)
 * Description: Coupe les Emoji, nettoie le <head>, et neutralise les sorties OG/Twitter concurrentes (Yoast/RankMath/Avada). Ce plugin ne génère AUCUNE meta (GLS_GroupLangSEO s’en charge).
 * Author: Cyril Signature
 * Version: 1.0.2
 */

if (!defined('ABSPATH')) exit;

/* -------------------------------------------------
 * 0) PERFORMANCE : couper les Emoji WordPress partout
 * ------------------------------------------------- */
add_action('init', function () {
	remove_action('admin_print_scripts', 'print_emoji_detection_script');
	remove_action('admin_print_styles',  'print_emoji_styles');
	remove_action('wp_head',             'print_emoji_detection_script', 7);
	remove_action('wp_print_styles',     'print_emoji_styles');
	remove_filter('the_content_feed',    'wp_staticize_emoji');
	remove_filter('comment_text_rss',    'wp_staticize_emoji');
	remove_filter('wp_mail',             'wp_staticize_emoji_for_email');
}, 1);

/* ----------------------------------------------------------
 * 1) NETTOYAGE <head> : liens et sorties WP non indispensables
 * ---------------------------------------------------------- */
add_action('init', function () {
	// REST API links + header
	remove_action('wp_head',           'rest_output_link_wp_head');
	remove_action('template_redirect', 'rest_output_link_header', 11);

	// oEmbed discovery + host js
	remove_action('wp_head', 'wp_oembed_add_discovery_links');
	remove_action('wp_head', 'wp_oembed_add_host_js');

	// Feeds automatiques
	remove_action('wp_head', 'feed_links', 2);
	remove_action('wp_head', 'feed_links_extra', 3);

	// RSD, WLW, Shortlink, Generator (version WP)
	remove_action('wp_head', 'rsd_link');
	remove_action('wp_head', 'wlwmanifest_link');
	remove_action('wp_head', 'wp_shortlink_wp_head');
	remove_action('wp_head', 'wp_generator');
}, 9);

/* ----------------------------------------------------------------
 * 2) ANTI-DOUBLONS : neutraliser OG/Twitter d’autres extensions
 *    -> On ne génère aucune balise ici. On coupe seulement les autres.
 * ---------------------------------------------------------------- */
add_action('init', function () {
	/* === Yoast SEO === */
	// Désactive via filtres officiels.
	add_filter('wpseo_opengraph_enabled',      '__return_false', 99);
	add_filter('wpseo_output_twitter_card',    '__return_false', 99);
	add_filter('wpseo_twitter_card_type',      '__return_false', 99);
	// Ceinture/bretelles : retire les presenters OG/Twitter s’ils sont listés.
	add_filter('wpseo_frontend_presenter_classes', function ($presenters) {
		if (!is_array($presenters)) return $presenters;
		$blocked_ns = [
			'Yoast\\WP\\SEO\\Presenters\\Open_Graph\\',
			'Yoast\\WP\\SEO\\Presenters\\Twitter\\',
		];
		return array_values(array_filter($presenters, function ($class) use ($blocked_ns) {
			foreach ($blocked_ns as $ns) {
				if (strpos($class, $ns) === 0) return false;
			}
			return true;
		}));
	}, 200);

	/* === Rank Math === */
	add_filter('rank_math/opengraph/facebook/enabled', '__return_false', 99);
	add_filter('rank_math/opengraph/twitter/enabled',  '__return_false', 99);
	// Si Rank Math a injecté un head proxy.
	if (has_action('rank_math/head')) {
		remove_all_actions('rank_math/head');
	}

	/* === Hooks Yoast “legacy” au cas où === */
	remove_all_actions('wpseo_opengraph');
	remove_all_actions('wpseo_twitter');
}, 20);

/* --------------------------------------------------------------
 * 2.b) Avada : retirer les sorties OG/Twitter du thème si présentes
 * -------------------------------------------------------------- */
add_action('after_setup_theme', function () {
	if (function_exists('Avada')) {
		$head = is_object(Avada()) && isset(Avada()->head) ? Avada()->head : null;
		if ($head) {
			// Avada attache des méthodes d’instance sur wp_head avec priorité basse.
			remove_action('wp_head', [$head, 'og_tags'],       5);
			remove_action('wp_head', [$head, 'twitter_card'],  5);
		}
	}
}, 20);

/* ----------------------------------------------------------
 * 3) BONUS UX : s’assurer que les PAGES ont un excerpt (utile GLS)
 * ---------------------------------------------------------- */
add_action('init', function () {
	add_post_type_support('page', 'excerpt');
}, 5);

/* ----------------------------------------------------------
 * 4) GARANTIE : ce plugin n’émet AUCUNE balise meta.
 * ---------------------------------------------------------- */
// Intentionnellement vide.