<?php
/**
 * Avada Options.
 *
 * @author     ThemeFusion
 * @copyright  (c) Copyright by ThemeFusion
 * @link       https://avada.com
 * @package    Avada
 * @subpackage Core
 * @since      4.0.0
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/**
 * Page Title Bar
 *
 * @param array $sections An array of our sections.
 * @return array
 */
function avada_options_section_breadcrumbs( $sections ) {
	$info = [];

	if ( function_exists( 'yoast_breadcrumb' ) ) {
		$info = [
			'type'        => 'custom',
			'description' => '<div class="fusion-redux-important-notice">' . esc_attr__( 'Yoast SEO plugin is active, and its breadcrumb function is overwriting Avada\'s output.', 'fusion-builder' ) . '</div>',
			'id'          => 'breadcrumb_info',

		];
	} else if ( function_exists( 'rank_math_get_breadcrumbs' ) ) {
		$info = [
			'type'        => 'custom',
			'description' => '<div class="fusion-redux-important-notice">' . esc_attr__( 'RankMath SEO plugin is active, and its breadcrumb function is overwriting Avada\'s output.', 'fusion-builder' ) . '</div>',
			'id'          => 'breadcrumb_info',
		];
	}

	$sections['breadcrumbs'] = [
		'label'    => esc_html__( 'Breadcrumbs', 'Avada' ),
		'id'       => 'heading_breadcrumbs',
		'priority' => 7,
		'icon'     => 'el-icon-chevron-right',
		'alt_icon' => 'fusiona-breadcrumb',
		'fields'   => [
			$info,
			'breadcrumb_mobile'                 => [
				'label'           => esc_html__( 'Breadcrumbs on Mobile Devices', 'Avada' ),
				'description'     => esc_html__( 'Turn on to display breadcrumbs on mobile devices.', 'Avada' ),
				'id'              => 'breadcrumb_mobile',
				'default'         => '0',
				'type'            => 'switch',
				'soft_dependency' => true,
				'output'          => [
					[
						'element'           => 'helperElement',
						'property'          => 'dummy',
						'callback'          => [
							'toggle_class',
							[
								'condition' => [ '', 'false' ],
								'element'   => 'body',
								'className' => 'avada-has-breadcrumb-mobile-hidden',
							],
						],
						'sanitize_callback' => '__return_empty_string',
					],
				],
			],
			'breacrumb_prefix'                  => [
				'label'           => esc_html__( 'Breadcrumbs Prefix', 'Avada' ),
				'description'     => esc_html__( 'Controls the text before the breadcrumb menu.', 'Avada' ),
				'id'              => 'breacrumb_prefix',
				'default'         => '',
				'type'            => 'text',
				'soft_dependency' => true,
				'partial_refresh' => [
					'page_title_bar_contents_breacrumb_prefix' => [
						'selector'              => '.avada-page-titlebar-wrapper',
						'container_inclusive'   => false,
						'render_callback'       => [ 'Avada_Partial_Refresh_Callbacks', 'page_titlebar_wrapper' ],
						'success_trigger_event' => 'fusion-ptb-refreshed',
					],
				],
			],
			'breacrumb_home_label'              => [
				'label'           => esc_html__( 'Breadcrumbs Home Anchor Text', 'Avada' ),
				'description'     => esc_html__( 'Controls the text anchor of the Homelink. Leave empty for translatable default of "Home".', 'Avada' ),
				'id'              => 'breacrumb_home_label',
				'default'         => '',
				'type'            => 'text',
				'soft_dependency' => true,
				'partial_refresh' => [
					'page_title_bar_contents_breacrumb_home_label' => [
						'selector'              => '.avada-page-titlebar-wrapper',
						'container_inclusive'   => false,
						'render_callback'       => [ 'Avada_Partial_Refresh_Callbacks', 'page_titlebar_wrapper' ],
						'success_trigger_event' => 'fusion-ptb-refreshed',
					],
				],
			],
			'breadcrumb_separator'              => [
				'label'           => esc_html__( 'Breadcrumbs Separator', 'Avada' ),
				'description'     => esc_html__( 'Controls the type of separator between each breadcrumb.', 'Avada' ),
				'id'              => 'breadcrumb_separator',
				'default'         => '/',
				'type'            => 'text',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'          => '--breadcrumbs_separator',
						'element'       => '.fusion-page-title-bar, .fusion-breadcrumbs .awb-breadcrumb-sep',
						'value_pattern' => '"$"',
						'callback'      => [
							'replace_chars',
							[
								'replacements' => [ '\\' => '\\\\' ],
							],
						],
					],
				],
			],
			'breadcrumbs_font_size'             => [
				'label'           => esc_html__( 'Breadcrumbs Font Size', 'Avada' ),
				'description'     => esc_html__( 'Controls the font size for the breadcrumbs text.', 'Avada' ),
				'id'              => 'breadcrumbs_font_size',
				'default'         => '14px',
				'type'            => 'dimension',
				'choices'         => [
					'units' => [ 'px', 'em' ],
				],
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'    => '--breadcrumbs_font_size',
						'element' => '.fusion-page-title-bar, .fusion-breadcrumbs',
					],
				],
			],
			'breadcrumbs_text_color'            => [
				'label'           => esc_html__( 'Breadcrumbs Text Color', 'Avada' ),
				'description'     => esc_html__( 'Controls the text color of the breadcrumbs font.', 'Avada' ),
				'id'              => 'breadcrumbs_text_color',
				'default'         => 'var(--awb-color8)',
				'type'            => 'color-alpha',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'     => '--breadcrumbs_text_color',
						'element'  => '.fusion-page-title-bar, .fusion-breadcrumbs',
						'callback' => [ 'sanitize_color' ],
					],
				],
			],
			'breadcrumbs_text_hover_color'      => [
				'label'           => esc_html__( 'Breadcrumbs Text Hover Color', 'Avada' ),
				'description'     => esc_html__( 'Controls the text hover color of the breadcrumbs font.', 'Avada' ),
				'id'              => 'breadcrumbs_text_hover_color',
				'default'         => 'var(--awb-color4)',
				'type'            => 'color-alpha',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'     => '--breadcrumbs_text_hover_color',
						'element'  => '.fusion-page-title-bar, .fusion-breadcrumbs',
						'callback' => [ 'sanitize_color' ],
					],
				],
			],
			'breadcrumbs_prefix_color'       => [
				'label'           => esc_html__( 'Breadcrumbs Prefix Color', 'Avada' ),
				'description'     => esc_html__( 'Controls the text color of the breadcrumbs prefix. Leave empty to use the text color above.', 'Avada' ),
				'id'              => 'breadcrumbs_prefix_color',
				'default'         => '',
				'type'            => 'color-alpha',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'     => '--breadcrumbs_prefix_color',
						'element'  => '.fusion-page-title-bar, .fusion-breadcrumbs',
					],
				],
			],			
			'breadcrumbs_current_page_color'       => [
				'label'           => esc_html__( 'Breadcrumbs Current Page Color', 'Avada' ),
				'description'     => esc_html__( 'Controls the text color of the current page in the breadcrumbs path. Leave empty to use the text color above.', 'Avada' ),
				'id'              => 'breadcrumbs_current_page_color',
				'default'         => '',
				'type'            => 'color-alpha',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'     => '--breadcrumbs_current_page_color',
						'element'  => '.fusion-page-title-bar, .fusion-breadcrumbs',
					],
				],
			],
			'breadcrumbs_separator_color'       => [
				'label'           => esc_html__( 'Breadcrumbs Separator Color', 'Avada' ),
				'description'     => esc_html__( 'Controls the separator color of the breadcrumbs. Leave empty to use the text color above.', 'Avada' ),
				'id'              => 'breadcrumbs_separator_color',
				'default'         => '',
				'type'            => 'color-alpha',
				'soft_dependency' => true,
				'css_vars'        => [
					[
						'name'     => '--breadcrumbs_separator_color',
						'element'  => '.fusion-page-title-bar, .fusion-breadcrumbs',
					],
				],
			],
			'breadcrumb_show_categories'        => [
				'label'           => esc_html__( 'Post Categories/Terms on Breadcrumbs', 'Avada' ),
				'description'     => esc_html__( 'Turn on to display the post categories/terms in the breadcrumbs path.', 'Avada' ),
				'id'              => 'breadcrumb_show_categories',
				'default'         => '1',
				'type'            => 'switch',
				'soft_dependency' => true,
				'partial_refresh' => [
					'page_title_bar_contents_breadcrumb_show_categories' => [
						'selector'              => '.avada-page-titlebar-wrapper',
						'container_inclusive'   => false,
						'render_callback'       => [ 'Avada_Partial_Refresh_Callbacks', 'page_titlebar_wrapper' ],
						'success_trigger_event' => 'fusion-ptb-refreshed',
					],
				],
			],
			'breadcrumb_show_post_type_archive' => [
				'label'           => esc_html__( 'Post Type Archives on Breadcrumbs', 'Avada' ),
				'description'     => esc_html__( 'Turn on to display post type archives in the breadcrumbs path.', 'Avada' ),
				'id'              => 'breadcrumb_show_post_type_archive',
				'default'         => '0',
				'type'            => 'switch',
				'soft_dependency' => true,
				'partial_refresh' => [
					'page_title_bar_contents_breadcrumb_show_post_type_archive' => [
						'selector'              => '.avada-page-titlebar-wrapper',
						'container_inclusive'   => false,
						'render_callback'       => [ 'Avada_Partial_Refresh_Callbacks', 'page_titlebar_wrapper' ],
						'success_trigger_event' => 'fusion-ptb-refreshed',
					],
				],
			],
			'breadcrumb_show_leaf'              => [
				'label'           => esc_html__( 'Post Name on Breadcrumbs', 'Avada' ),
				'description'     => esc_html__( 'Turn on to display the post name in the breadcrumbs path.', 'Avada' ),
				'id'              => 'breadcrumb_show_leaf',
				'default'         => '1',
				'type'            => 'switch',
				'soft_dependency' => true,
				'partial_refresh' => [
					'page_title_bar_contents_breadcrumb_show_leaf' => [
						'selector'              => '.avada-page-titlebar-wrapper',
						'container_inclusive'   => false,
						'render_callback'       => [ 'Avada_Partial_Refresh_Callbacks', 'page_titlebar_wrapper' ],
						'success_trigger_event' => 'fusion-ptb-refreshed',
					],
				],
			],
		],
	];

	return $sections;

}
